<?php $__env->startSection('content'); ?>
<div class="pb-60 pt-60">
    <div class="container">

        <div class="row notice"></div>
        
        <div class="row justify-content-center">
            <div class="col-md-12">
                <?php if($user->deposit_wallet <= 0 && $user->interest_wallet <= 0): ?>
                    <div class="alert border border--danger" role="alert">
                        <div class="alert__icon d-flex align-items-center text--danger"><i
                                class="fas fa-exclamation-triangle"></i></div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('Empty Balance'); ?></span><br>
                            <small><i><?php echo app('translator')->get('Your balance is empty. Please make'); ?> <a href="<?php echo e(route('user.deposit.index')); ?>"
                                        class="link-color"><?php echo app('translator')->get('deposit'); ?></a> <?php echo app('translator')->get('for your next investment.'); ?></i></small>
                        </p>
                    </div>
                <?php endif; ?>

                <?php if($user->deposits->where('status',1)->count() == 1 && !$user->invests->count()): ?>
                    <div class="alert border border--success" role="alert">
                        <div class="alert__icon d-flex align-items-center text--success"><i class="fas fa-check"></i>
                        </div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('First Deposit'); ?></span><br>
                            <small><i><span class="fw-bold"><?php echo app('translator')->get('Congratulations!'); ?></span> <?php echo app('translator')->get('You\'ve made your first deposit successfully. Go to'); ?> <a
                                        href="<?php echo e(route('plan')); ?>" class="link-color"><?php echo app('translator')->get('investment plan'); ?></a>
                                    <?php echo app('translator')->get('page and invest now'); ?></i></small>
                        </p>
                    </div>
                <?php endif; ?>

                <?php if($pendingWithdrawals): ?>
                    <div class="alert border border--primary" role="alert">
                        <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i>
                        </div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('Withdrawal Pending'); ?></span><br>
                            <small><i><?php echo app('translator')->get('Total'); ?> <?php echo e(showAmount($pendingWithdrawals)); ?> <?php echo e($general->cur_text); ?>

                                    <?php echo app('translator')->get('withdrawal request is pending. Please wait for admin approval. The amount will send to the account which you\'ve provided. See'); ?> <a href="<?php echo e(route('user.withdraw.history')); ?>"
                                        class="link-color"><?php echo app('translator')->get('withdrawal history'); ?></a></i></small>
                        </p>
                    </div>
                <?php endif; ?>

                <?php if($pendingDeposits): ?>
                    <div class="alert border border--primary" role="alert">
                        <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i>
                        </div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('Deposit Pending'); ?></span><br>
                            <small><i><?php echo app('translator')->get('Total'); ?> <?php echo e(showAmount($pendingDeposits)); ?> <?php echo e($general->cur_text); ?>

                                    <?php echo app('translator')->get('deposit request is pending. Please wait for admin approval. See'); ?> <a href="<?php echo e(route('user.deposit.history')); ?>"
                                        class="link-color"><?php echo app('translator')->get('deposit history'); ?></a></i></small>
                        </p>
                    </div>
                <?php endif; ?>

                <?php if(!$user->ts): ?>
                    <div class="alert border border--warning" role="alert">
                        <div class="alert__icon d-flex align-items-center text--warning"><i
                                class="fas fa-user-lock"></i></div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('2FA Authentication'); ?></span><br>
                            <small><i><?php echo app('translator')->get('To keep safe your account, Please enable'); ?> <a href="<?php echo e(route('user.twofactor')); ?>"
                                        class="link-color"><?php echo app('translator')->get('2FA'); ?></a> <?php echo app('translator')->get('security'); ?>.</i>
                                <?php echo app('translator')->get('It will make secure your account and balance.'); ?></small>
                        </p>
                    </div>
                <?php endif; ?>

                <?php if($isHoliday): ?>
                    <div class="alert border border--info" role="alert">
                        <div class="alert__icon d-flex align-items-center text--info"><i class="fas fa-toggle-off"></i>
                        </div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('Holiday'); ?></span><br>
                            <small><i><?php echo app('translator')->get('Today is holiday on this system. You\'ll not get any interest today from this system. Also you\'re unable to make withdrawal request today.'); ?> <br> <?php echo app('translator')->get('The next working day is coming after'); ?> <span id="counter"
                                        class="fw-bold text--primary fs--15px"></span></i></small>
                        </p>
                    </div>
                <?php endif; ?>

                <?php if($user->kv == 0): ?>
                    <div class="alert border border--info" role="alert">
                        <div class="alert__icon d-flex align-items-center text--info"><i class="fas fa-file-signature"></i>
                        </div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Required'); ?></span><br>
                            <small><i><?php echo app('translator')->get('Please submit the required KYC information to verify yourself. Otherwise, you couldn\'t make any withdrawal requests to the system.'); ?> <a href="<?php echo e(route('user.kyc.form')); ?>"
                                        class="link-color"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to submit KYC information'); ?>.</i></small>
                        </p>
                    </div>
                <?php elseif($user->kv == 2): ?>
                    <div class="alert border border--warning" role="alert">
                        <div class="alert__icon d-flex align-items-center text--warning"><i
                                class="fas fa-user-check"></i></div>
                        <p class="alert__message">
                            <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Pending'); ?></span><br>
                            <small><i><?php echo app('translator')->get('Your submitted KYC information is pending for admin approval. Please wait till that.'); ?> <a href="<?php echo e(route('user.kyc.data')); ?>"
                                        class="link-color"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to see your submitted information'); ?></i></small>
                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-12 mt-lg-0 mt-5">
                <div class="row mb-none-30">
                    <div class="col-xl-4 col-sm-6 mb-30">
                        <div class="d-widget d-flex justify-content-between gap-5">
                            <div class="left-content">
                                <span class="caption"><?php echo app('translator')->get('Deposit Wallet Balance'); ?></span>
                                <h4 class="currency-amount"><?php echo e($general->cur_sym); ?><?php echo e(getAmount($user->deposit_wallet)); ?></h4>
                            </div>
                            <div class="icon ms-auto">
                                <i class="las la-dollar-sign"></i>
                            </div>
                        </div><!-- d-widget-two end -->
                    </div>
                    <div class="col-xl-4 col-sm-6 mb-30">
                        <div class="d-widget d-flex justify-content-between gap-5">
                            <div class="left-content">
                                <span class="caption"><?php echo app('translator')->get('Interest Wallet Balance'); ?></span>
                                <h4 class="currency-amount">
                                    <?php echo e($general->cur_sym); ?><?php echo e(getAmount($user->interest_wallet)); ?></h4>
                            </div>
                            <div class="icon ms-auto">
                                <i class="las la-wallet"></i>
                            </div>
                        </div><!-- d-widget-two end -->
                    </div>
                    <div class="col-xl-4 col-sm-6 mb-30">
                        <div class="d-widget d-flex justify-content-between gap-5">
                            <div class="left-content">
                                <span class="caption"><?php echo app('translator')->get('Total Invest'); ?></span>
                                <h4 class="currency-amount">
                                    <?php echo e($general->cur_sym); ?><?php echo e(getAmount($totalInvest)); ?>

                                </h4>
                            </div>
                            <div class="icon ms-auto">
                                <i class="las la-cubes "></i>
                            </div>
                        </div><!-- d-widget-two end -->
                    </div>
                    <div class="col-xl-4 col-sm-6 mb-30">
                        <div class="d-widget d-flex justify-content-between gap-5">
                            <div class="left-content">
                                <span class="caption"><?php echo app('translator')->get('Total Deposit'); ?></span>
                                <h4 class="currency-amount">
                                    <?php echo e($general->cur_sym); ?><?php echo e(getAmount($user->deposits->where('status',1)->sum('amount'))); ?>

                                </h4>
                            </div>
                            <div class="icon ms-auto">
                                <i class="las la-credit-card"></i>
                            </div>
                        </div><!-- d-widget-two end -->
                    </div>
                    <div class="col-xl-4 col-sm-6 mb-30">
                        <div class="d-widget d-flex justify-content-between gap-5">
                            <div class="left-content">
                                <span class="caption"><?php echo app('translator')->get('Total Withdraw'); ?></span>
                                <h4 class="currency-amount">
                                    <?php echo e($general->cur_sym); ?><?php echo e(getAmount($user->withdrawals->where('status',1)->sum('amount'))); ?>

                                </h4>
                            </div>
                            <div class="icon ms-auto">
                                <i class="las la-cloud-download-alt"></i>
                            </div>
                        </div><!-- d-widget-two end -->
                    </div>
                    <div class="col-xl-4 col-sm-6 mb-30">
                        <div class="d-widget d-flex justify-content-between gap-5">
                            <div class="left-content">
                                <span class="caption"><?php echo app('translator')->get('Referral Earnings'); ?></span>
                                <h4 class="currency-amount">
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($referral_earnings)); ?>

                                </h4>
                            </div>
                            <div class="icon ms-auto">
                                <i class="las la-user-friends"></i>
                            </div>
                        </div><!-- d-widget-two end -->
                    </div>
                </div><!-- row end -->
               
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        #copyBoard {
            cursor: pointer;
        }

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
 <script>
        'use strict';
        (function ($) {
            <?php if($isHoliday): ?>
                function createCountDown(elementId, sec) {
                    var tms = sec;
                    var x = setInterval(function () {
                        var distance = tms * 1000;
                        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                        var days = `<span>${days}d</span>`;
                        var hours = `<span>${hours}h</span>`;
                        var minutes = `<span>${minutes}m</span>`;
                        var seconds = `<span>${seconds}s</span>`;
                        document.getElementById(elementId).innerHTML = days +' '+ hours + " " + minutes + " " + seconds;
                        if (distance < 0) {
                            clearInterval(x);
                            document.getElementById(elementId).innerHTML = "COMPLETE";
                        }
                        tms--;
                    }, 1000);
                }

                createCountDown('counter', <?php echo e(\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds()); ?>);
            <?php endif; ?>
        })(jQuery);
 </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u452099573/domains/alpha7x.com/public_html/core/resources/views/templates/bit_gold/user/dashboard.blade.php ENDPATH**/ ?>